/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.IdentityHashMap;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class FlatUIUtils {
    private static boolean useSharedUIs = true;
    private static final WeakHashMap<LookAndFeel, IdentityHashMap<Object, ComponentUI>> sharedUIinstances = new WeakHashMap();
    private static UIDefaults lightAWTPeerDefaults;
    public static final double MOVE_TO = -1.000000000001E12;
    public static final double QUAD_TO = -1.000000000002E12;
    public static final double CURVE_TO = -1.000000000003E12;
    public static final double ROUNDED = -1.000000000004E12;
    public static final double CLOSE_PATH = -1.000000000005E12;

    public static Rectangle addInsets(Rectangle r2, Insets insets) {
        return new Rectangle(r2.x - insets.left, r2.y - insets.top, r2.width + insets.left + insets.right, r2.height + insets.top + insets.bottom);
    }

    public static Rectangle subtractInsets(Rectangle r2, Insets insets) {
        return new Rectangle(r2.x + insets.left, r2.y + insets.top, r2.width - insets.left - insets.right, r2.height - insets.top - insets.bottom);
    }

    public static Dimension addInsets(Dimension dim, Insets insets) {
        return new Dimension(dim.width + insets.left + insets.right, dim.height + insets.top + insets.bottom);
    }

    public static Insets addInsets(Insets insets1, Insets insets2) {
        if (insets1 == null) {
            return insets2;
        }
        if (insets2 == null) {
            return insets1;
        }
        return new Insets(insets1.top + insets2.top, insets1.left + insets2.left, insets1.bottom + insets2.bottom, insets1.right + insets2.right);
    }

    public static void setInsets(Insets dest, Insets src) {
        dest.top = src.top;
        dest.left = src.left;
        dest.bottom = src.bottom;
        dest.right = src.right;
    }

    public static Color getUIColor(String key, int defaultColorRGB) {
        Color color = UIManager.getColor(key);
        return color != null ? color : new Color(defaultColorRGB);
    }

    public static Color getUIColor(String key, Color defaultColor) {
        Color color = UIManager.getColor(key);
        return color != null ? color : defaultColor;
    }

    public static Color getUIColor(String key, String defaultKey) {
        Color color = UIManager.getColor(key);
        return color != null ? color : UIManager.getColor(defaultKey);
    }

    public static boolean getUIBoolean(String key, boolean defaultValue) {
        Object value = UIManager.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static int getUIInt(String key, int defaultValue) {
        Object value = UIManager.get(key);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    public static float getUIFloat(String key, float defaultValue) {
        Object value = UIManager.get(key);
        return value instanceof Number ? ((Number)value).floatValue() : defaultValue;
    }

    public static <T extends Enum<T>> T getUIEnum(String key, Class<T> enumType, T defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof String) {
            try {
                return Enum.valueOf(enumType, (String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Color getSubUIColor(String key, String subKey) {
        Color value;
        if (subKey != null && (value = UIManager.getColor(FlatUIUtils.buildSubKey(key, subKey))) != null) {
            return value;
        }
        return UIManager.getColor(key);
    }

    public static boolean getSubUIBoolean(String key, String subKey, boolean defaultValue) {
        Object value;
        if (subKey != null && (value = UIManager.get(FlatUIUtils.buildSubKey(key, subKey))) instanceof Boolean) {
            return (Boolean)value;
        }
        return FlatUIUtils.getUIBoolean(key, defaultValue);
    }

    public static int getSubUIInt(String key, String subKey, int defaultValue) {
        Object value;
        if (subKey != null && (value = UIManager.get(FlatUIUtils.buildSubKey(key, subKey))) instanceof Integer) {
            return (Integer)value;
        }
        return FlatUIUtils.getUIInt(key, defaultValue);
    }

    public static Insets getSubUIInsets(String key, String subKey) {
        Insets value;
        if (subKey != null && (value = UIManager.getInsets(FlatUIUtils.buildSubKey(key, subKey))) != null) {
            return value;
        }
        return UIManager.getInsets(key);
    }

    public static Dimension getSubUIDimension(String key, String subKey) {
        Dimension value;
        if (subKey != null && (value = UIManager.getDimension(FlatUIUtils.buildSubKey(key, subKey))) != null) {
            return value;
        }
        return UIManager.getDimension(key);
    }

    public static Icon getSubUIIcon(String key, String subKey) {
        Icon value;
        if (subKey != null && (value = UIManager.getIcon(FlatUIUtils.buildSubKey(key, subKey))) != null) {
            return value;
        }
        return UIManager.getIcon(key);
    }

    public static Font getSubUIFont(String key, String subKey) {
        Font value;
        if (subKey != null && (value = UIManager.getFont(FlatUIUtils.buildSubKey(key, subKey))) != null) {
            return value;
        }
        return UIManager.getFont(key);
    }

    private static String buildSubKey(String key, String subKey) {
        int dot = key.lastIndexOf(46);
        return dot >= 0 ? key.substring(0, dot) + '.' + subKey + '.' + key.substring(dot + 1) : key;
    }

    public static boolean getBoolean(JComponent c2, String systemPropertyKey, String clientPropertyKey, String uiKey, boolean defaultValue) {
        Boolean value = FlatSystemProperties.getBooleanStrict(systemPropertyKey, null);
        if (value != null) {
            return value;
        }
        value = FlatClientProperties.clientPropertyBooleanStrict(c2, clientPropertyKey, null);
        if (value != null) {
            return value;
        }
        return FlatUIUtils.getUIBoolean(uiKey, defaultValue);
    }

    public static boolean isChevron(String arrowType) {
        return !"triangle".equals(arrowType);
    }

    public static Color nonUIResource(Color c2) {
        return c2 instanceof UIResource ? new Color(c2.getRGB(), true) : c2;
    }

    public static Font nonUIResource(Font font) {
        return font instanceof UIResource ? font.deriveFont(font.getStyle()) : font;
    }

    public static Border nonUIResource(Border border) {
        return border instanceof UIResource ? new NonUIResourceBorder(border) : border;
    }

    static Border unwrapNonUIResourceBorder(Border border) {
        return border instanceof NonUIResourceBorder ? ((NonUIResourceBorder)border).delegate : border;
    }

    public static int minimumWidth(JComponent c2, int minimumWidth) {
        return FlatClientProperties.clientPropertyInt(c2, "JComponent.minimumWidth", minimumWidth);
    }

    public static int minimumHeight(JComponent c2, int minimumHeight) {
        return FlatClientProperties.clientPropertyInt(c2, "JComponent.minimumHeight", minimumHeight);
    }

    public static boolean isCellEditor(Component c2) {
        if (c2 == null) {
            return false;
        }
        Component c22 = c2;
        for (int i2 = 0; i2 <= 2 && c22 != null; ++i2) {
            Container parent = c22.getParent();
            if (parent instanceof JTable && ((JTable)parent).getEditorComponent() == c22) {
                return true;
            }
            c22 = parent;
        }
        String name = c2.getName();
        if ("Table.editor".equals(name) || "Tree.cellEditor".equals(name)) {
            return true;
        }
        return c2 instanceof JComponent && Boolean.TRUE.equals(((JComponent)c2).getClientProperty("JComboBox.isTableCellEditor"));
    }

    public static boolean isPermanentFocusOwner(Component c2) {
        Object value;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (c2 instanceof JComponent && (value = ((JComponent)c2).getClientProperty("JComponent.focusOwner")) instanceof Predicate) {
            return ((Predicate)value).test((JComponent)c2) && FlatUIUtils.isInActiveWindow(c2, keyboardFocusManager.getActiveWindow());
        }
        if (c2.hasFocus()) {
            return true;
        }
        return keyboardFocusManager.getPermanentFocusOwner() == c2 && FlatUIUtils.isInActiveWindow(c2, keyboardFocusManager.getActiveWindow());
    }

    static boolean isInActiveWindow(Component c2, Window activeWindow) {
        Window window = SwingUtilities.windowForComponent(c2);
        return window == activeWindow || window != null && window.getType() == Window.Type.POPUP && window.getOwner() == activeWindow;
    }

    static boolean isAWTPeer(Component c2) {
        if (SystemInfo.isMacOS) {
            return c2.getClass().getName().startsWith("sun.lwawt.LW");
        }
        return false;
    }

    static boolean needsLightAWTPeer(JComponent c2) {
        return FlatUIUtils.isAWTPeer(c2) && FlatLaf.isLafDark();
    }

    static void runWithLightAWTPeerUIDefaults(Runnable runnable) {
        if (lightAWTPeerDefaults == null) {
            FlatLightLaf lightLaf = UIManager.getInt("Component.focusWidth") >= 2 ? new FlatIntelliJLaf() : new FlatLightLaf();
            lightAWTPeerDefaults = lightLaf.getDefaults();
        }
        FlatLaf.runWithUIDefaultsGetter(key -> {
            Object value = lightAWTPeerDefaults.get(key);
            return value != null ? value : FlatLaf.NULL_VALUE;
        }, runnable);
    }

    public static boolean isFullScreen(Component c2) {
        GraphicsConfiguration gc2 = c2.getGraphicsConfiguration();
        GraphicsDevice gd2 = gc2 != null ? gc2.getDevice() : null;
        Window fullScreenWindow = gd2 != null ? gd2.getFullScreenWindow() : null;
        return fullScreenWindow != null && fullScreenWindow == SwingUtilities.windowForComponent(c2);
    }

    public static Boolean isRoundRect(Component c2) {
        return c2 instanceof JComponent ? FlatClientProperties.clientPropertyBooleanStrict((JComponent)c2, "JComponent.roundRect", null) : null;
    }

    public static float getBorderFocusWidth(JComponent c2) {
        FlatBorder border = FlatUIUtils.getOutsideFlatBorder(c2);
        return border != null ? UIScale.scale((float)border.getFocusWidth(c2)) : 0.0f;
    }

    public static float getBorderLineWidth(JComponent c2) {
        FlatBorder border = FlatUIUtils.getOutsideFlatBorder(c2);
        return border != null ? UIScale.scale((float)border.getLineWidth(c2)) : 0.0f;
    }

    public static int getBorderFocusAndLineWidth(JComponent c2) {
        FlatBorder border = FlatUIUtils.getOutsideFlatBorder(c2);
        return border != null ? Math.round(UIScale.scale((float)border.getFocusWidth(c2)) + UIScale.scale((float)border.getLineWidth(c2))) : 0;
    }

    public static float getBorderArc(JComponent c2) {
        FlatBorder border = FlatUIUtils.getOutsideFlatBorder(c2);
        return border != null ? UIScale.scale((float)border.getArc(c2)) : 0.0f;
    }

    public static boolean hasRoundBorder(JComponent c2) {
        return FlatUIUtils.getBorderArc(c2) >= (float)c2.getHeight();
    }

    public static FlatBorder getOutsideFlatBorder(JComponent c2) {
        Border border = c2.getBorder();
        while (true) {
            if (border instanceof FlatBorder) {
                return (FlatBorder)border;
            }
            if (!(border instanceof CompoundBorder)) break;
            border = ((CompoundBorder)border).getOutsideBorder();
        }
        return null;
    }

    public static Object[] setRenderingHints(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        Object[] oldRenderingHints = new Object[]{g22.getRenderingHint(RenderingHints.KEY_ANTIALIASING), g22.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL)};
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g22.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        return oldRenderingHints;
    }

    public static void resetRenderingHints(Graphics g2, Object[] oldRenderingHints) {
        Graphics2D g22 = (Graphics2D)g2;
        if (oldRenderingHints[0] != null) {
            g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldRenderingHints[0]);
        }
        if (oldRenderingHints[1] != null) {
            g22.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldRenderingHints[1]);
        }
    }

    public static void runWithoutRenderingHints(Graphics g2, Object[] oldRenderingHints, Runnable runnable) {
        if (oldRenderingHints == null) {
            runnable.run();
            return;
        }
        Graphics2D g22 = (Graphics2D)g2;
        Object[] oldRenderingHints2 = new Object[]{g22.getRenderingHint(RenderingHints.KEY_ANTIALIASING), g22.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL)};
        FlatUIUtils.resetRenderingHints(g22, oldRenderingHints);
        runnable.run();
        FlatUIUtils.resetRenderingHints(g22, oldRenderingHints2);
    }

    public static Color deriveColor(Color color, Color baseColor) {
        return color instanceof DerivedColor ? ((DerivedColor)color).derive(baseColor) : color;
    }

    public static void paintComponentBackground(Graphics2D g2, int x2, int y2, int width, int height, float focusWidth, float arc) {
        FlatUIUtils.paintOutlinedComponent(g2, x2, y2, width, height, focusWidth, 0.0f, 0.0f, 0.0f, arc, null, null, g2.getPaint());
    }

    public static void paintOutlinedComponent(Graphics2D g2, int x3, int y3, int width, int height, float focusWidth, float focusWidthFraction, float focusInnerWidth, float borderWidth, float arc, Paint focusColor, Paint borderColor, Paint background) {
        double systemScaleFactor = UIScale.getSystemScaleFactor(g2);
        if (systemScaleFactor != 1.0 && systemScaleFactor != 2.0) {
            HiDPIUtils.paintAtScale1x(g2, x3, y3, width, height, (g2d, x2, y2, width2, height2, scaleFactor) -> FlatUIUtils.paintOutlinedComponentImpl(g2d, x2, y2, width2, height2, (float)((double)focusWidth * scaleFactor), focusWidthFraction, (float)((double)focusInnerWidth * scaleFactor), (float)((double)borderWidth * scaleFactor), (float)((double)arc * scaleFactor), focusColor, borderColor, background));
            return;
        }
        FlatUIUtils.paintOutlinedComponentImpl(g2, x3, y3, width, height, focusWidth, focusWidthFraction, focusInnerWidth, borderWidth, arc, focusColor, borderColor, background);
    }

    private static void paintOutlinedComponentImpl(Graphics2D g2, int x2, int y2, int width, int height, float focusWidth, float focusWidthFraction, float focusInnerWidth, float borderWidth, float arc, Paint focusColor, Paint borderColor, Paint background) {
        float x1 = (float)x2 + focusWidth;
        float y1 = (float)y2 + focusWidth;
        float w1 = (float)width - focusWidth * 2.0f;
        float h1 = (float)height - focusWidth * 2.0f;
        if (background != null) {
            g2.setPaint(background);
            g2.fill(FlatUIUtils.createComponentRectangle(x1, y1, w1, h1, arc));
        }
        if (borderColor != null && borderColor.equals(focusColor)) {
            borderColor = null;
            focusInnerWidth = Math.max(focusInnerWidth, borderWidth);
        }
        float paintedFocusWidth = focusWidth * focusWidthFraction + focusInnerWidth;
        if (focusColor != null && paintedFocusWidth != 0.0f) {
            float inset = focusWidth - focusWidth * focusWidthFraction;
            float x22 = (float)x2 + inset;
            float y22 = (float)y2 + inset;
            float w2 = (float)width - inset * 2.0f;
            float h2 = (float)height - inset * 2.0f;
            float outerArc = arc + focusWidth * 2.0f;
            float innerArc = arc - focusInnerWidth * 2.0f;
            if (focusWidth > 0.0f && arc > 0.0f && arc < (float)UIScale.scale(10)) {
                outerArc -= UIScale.scale(2.0f);
            }
            if (focusWidthFraction != 1.0f) {
                outerArc = arc + (outerArc - arc) * focusWidthFraction;
            }
            g2.setPaint(focusColor);
            FlatUIUtils.paintOutline(g2, x22, y22, w2, h2, paintedFocusWidth, outerArc, innerArc);
        }
        if (borderColor != null && borderWidth != 0.0f) {
            g2.setPaint(borderColor);
            FlatUIUtils.paintOutline(g2, x1, y1, w1, h1, borderWidth, arc);
        }
    }

    public static void paintOutline(Graphics2D g2, float x2, float y2, float w2, float h2, float lineWidth, float arc) {
        FlatUIUtils.paintOutline(g2, x2, y2, w2, h2, lineWidth, arc, arc - lineWidth * 2.0f);
    }

    public static void paintOutline(Graphics2D g2, float x2, float y2, float w2, float h2, float lineWidth, float arc, float innerArc) {
        if (lineWidth == 0.0f || w2 <= 0.0f || h2 <= 0.0f) {
            return;
        }
        float t2 = lineWidth;
        float t2x = t2 * 2.0f;
        Path2D.Float border = new Path2D.Float(0);
        border.append(FlatUIUtils.createComponentRectangle(x2, y2, w2, h2, arc), false);
        border.append(FlatUIUtils.createComponentRectangle(x2 + t2, y2 + t2, w2 - t2x, h2 - t2x, innerArc), false);
        g2.fill(border);
    }

    public static Shape createComponentRectangle(float x2, float y2, float w2, float h2, float arc) {
        if (arc <= 0.0f) {
            return new Rectangle2D.Float(x2, y2, w2, h2);
        }
        if (w2 == h2 && arc >= w2) {
            return new Ellipse2D.Float(x2, y2, w2, h2);
        }
        arc = Math.min(arc, Math.min(w2, h2));
        return new RoundRectangle2D.Float(x2, y2, w2, h2, arc, arc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paintFilledRectangle(Graphics g2, Color color, float x2, float y2, float w2, float h2) {
        Graphics2D g22 = (Graphics2D)g2.create();
        try {
            FlatUIUtils.setRenderingHints(g22);
            g22.setColor(color);
            g22.fill(new Rectangle2D.Float(x2, y2, w2, h2));
        }
        finally {
            g22.dispose();
        }
    }

    public static void paintSelection(Graphics2D g2, int x3, int y3, int width, int height, Insets insets, float arcTopLeft, float arcTopRight, float arcBottomLeft, float arcBottomRight, int flags) {
        if (insets != null) {
            x3 += insets.left;
            y3 += insets.top;
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        if (arcTopLeft > 0.0f || arcTopRight > 0.0f || arcBottomLeft > 0.0f || arcBottomRight > 0.0f) {
            double systemScaleFactor = UIScale.getSystemScaleFactor(g2);
            if (systemScaleFactor != 1.0 && systemScaleFactor != 2.0) {
                HiDPIUtils.paintAtScale1x(g2, x3, y3, width, height, (g2d, x2, y2, width2, height2, scaleFactor) -> FlatUIUtils.paintRoundedSelectionImpl(g2d, x2, y2, width2, height2, (float)((double)arcTopLeft * scaleFactor), (float)((double)arcTopRight * scaleFactor), (float)((double)arcBottomLeft * scaleFactor), (float)((double)arcBottomRight * scaleFactor)));
            } else {
                FlatUIUtils.paintRoundedSelectionImpl(g2, x3, y3, width, height, arcTopLeft, arcTopRight, arcBottomLeft, arcBottomRight);
            }
        } else {
            g2.fillRect(x3, y3, width, height);
        }
    }

    private static void paintRoundedSelectionImpl(Graphics2D g2, int x2, int y2, int width, int height, float arcTopLeft, float arcTopRight, float arcBottomLeft, float arcBottomRight) {
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
        g2.fill(FlatUIUtils.createRoundRectanglePath(x2, y2, width, height, arcTopLeft, arcTopRight, arcBottomLeft, arcBottomRight));
        FlatUIUtils.resetRenderingHints(g2, oldRenderingHints);
    }

    public static void paintGrip(Graphics g2, int x2, int y2, int width, int height, boolean horizontal, int dotCount, int dotSize, int gap, boolean centerPrecise) {
        float gy2;
        float gx2;
        dotSize = UIScale.scale(dotSize);
        gap = UIScale.scale(gap);
        int gripSize = dotSize * dotCount + gap * (dotCount - 1);
        if (horizontal) {
            gx2 = x2 + Math.round((float)(width - gripSize) / 2.0f);
            gy2 = (float)y2 + (float)(height - dotSize) / 2.0f;
            if (!centerPrecise) {
                gy2 = Math.round(gy2);
            }
        } else {
            gx2 = (float)x2 + (float)(width - dotSize) / 2.0f;
            gy2 = y2 + Math.round((float)(height - gripSize) / 2.0f);
            if (!centerPrecise) {
                gx2 = Math.round(gx2);
            }
        }
        for (int i2 = 0; i2 < dotCount; ++i2) {
            ((Graphics2D)g2).fill(new Ellipse2D.Float(gx2, gy2, dotSize, dotSize));
            if (horizontal) {
                gx2 += (float)(dotSize + gap);
                continue;
            }
            gy2 += (float)(dotSize + gap);
        }
    }

    public static void paintParentBackground(Graphics g2, JComponent c2) {
        Color background = FlatUIUtils.getParentBackground(c2);
        if (background != null) {
            g2.setColor(background);
            g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
        }
    }

    public static Color getParentBackground(JComponent c2) {
        Color background;
        Container parent = FlatUIUtils.findOpaqueParent(c2);
        Color color = background = parent != null ? parent.getBackground() : null;
        if (background != null) {
            return background;
        }
        if (FlatUIUtils.isAWTPeer(c2)) {
            return c2 instanceof JTextField || c2 instanceof JScrollPane || c2.getBackground() == null ? SystemColor.window : c2.getBackground();
        }
        return UIManager.getColor("Panel.background");
    }

    private static Container findOpaqueParent(Container c2) {
        while ((c2 = c2.getParent()) != null) {
            if (!c2.isOpaque()) continue;
            return c2;
        }
        return null;
    }

    public static Path2D createRectangle(float x2, float y2, float width, float height, float lineWidth) {
        Path2D.Float path = new Path2D.Float(0);
        path.append(new Rectangle2D.Float(x2, y2, width, height), false);
        path.append(new Rectangle2D.Float(x2 + lineWidth, y2 + lineWidth, width - lineWidth * 2.0f, height - lineWidth * 2.0f), false);
        return path;
    }

    public static Path2D createRoundRectangle(float x2, float y2, float width, float height, float lineWidth, float arcTopLeft, float arcTopRight, float arcBottomLeft, float arcBottomRight) {
        Path2D.Float path = new Path2D.Float(0);
        path.append(FlatUIUtils.createRoundRectanglePath(x2, y2, width, height, arcTopLeft, arcTopRight, arcBottomLeft, arcBottomRight), false);
        path.append(FlatUIUtils.createRoundRectanglePath(x2 + lineWidth, y2 + lineWidth, width - lineWidth * 2.0f, height - lineWidth * 2.0f, arcTopLeft - lineWidth, arcTopRight - lineWidth, arcBottomLeft - lineWidth, arcBottomRight - lineWidth), false);
        return path;
    }

    public static Shape createRoundRectanglePath(float x2, float y2, float width, float height, float arcTopLeft, float arcTopRight, float arcBottomLeft, float arcBottomRight) {
        if (arcTopLeft <= 0.0f && arcTopRight <= 0.0f && arcBottomLeft <= 0.0f && arcBottomRight <= 0.0f) {
            return new Rectangle2D.Float(x2, y2, width, height);
        }
        float maxArc = Math.min(width, height) / 2.0f;
        arcTopLeft = arcTopLeft > 0.0f ? Math.min(arcTopLeft, maxArc) : 0.0f;
        arcTopRight = arcTopRight > 0.0f ? Math.min(arcTopRight, maxArc) : 0.0f;
        arcBottomLeft = arcBottomLeft > 0.0f ? Math.min(arcBottomLeft, maxArc) : 0.0f;
        arcBottomRight = arcBottomRight > 0.0f ? Math.min(arcBottomRight, maxArc) : 0.0f;
        float x22 = x2 + width;
        float y22 = y2 + height;
        double c2 = 0.5522847498307933;
        double ci2 = 1.0 - c2;
        double ciTopLeft = (double)arcTopLeft * ci2;
        double ciTopRight = (double)arcTopRight * ci2;
        double ciBottomLeft = (double)arcBottomLeft * ci2;
        double ciBottomRight = (double)arcBottomRight * ci2;
        Path2D.Float rect = new Path2D.Float(1, 16);
        ((Path2D)rect).moveTo(x22 - arcTopRight, y2);
        ((Path2D)rect).curveTo((double)x22 - ciTopRight, y2, x22, (double)y2 + ciTopRight, x22, y2 + arcTopRight);
        ((Path2D)rect).lineTo(x22, y22 - arcBottomRight);
        ((Path2D)rect).curveTo(x22, (double)y22 - ciBottomRight, (double)x22 - ciBottomRight, y22, x22 - arcBottomRight, y22);
        ((Path2D)rect).lineTo(x2 + arcBottomLeft, y22);
        ((Path2D)rect).curveTo((double)x2 + ciBottomLeft, y22, x2, (double)y22 - ciBottomLeft, x2, y22 - arcBottomLeft);
        ((Path2D)rect).lineTo(x2, y2 + arcTopLeft);
        ((Path2D)rect).curveTo(x2, (double)y2 + ciTopLeft, (double)x2 + ciTopLeft, y2, x2 + arcTopLeft, y2);
        rect.closePath();
        return rect;
    }

    public static Shape createRoundTrianglePath(float x1, float y1, float x2, float y2, float x3, float y3, float arc) {
        double averageSideLength = (FlatUIUtils.distance(x1, y1, x2, y2) + FlatUIUtils.distance(x2, y2, x3, y3) + FlatUIUtils.distance(x3, y3, x1, y1)) / 3.0;
        double t1 = 1.0 / averageSideLength * (double)arc;
        double t2 = 1.0 - t1;
        return FlatUIUtils.createPath(FlatUIUtils.lerp(x3, x1, t2), FlatUIUtils.lerp(y3, y1, t2), -1.000000000002E12, x1, y1, FlatUIUtils.lerp(x1, x2, t1), FlatUIUtils.lerp(y1, y2, t1), FlatUIUtils.lerp(x1, x2, t2), FlatUIUtils.lerp(y1, y2, t2), -1.000000000002E12, x2, y2, FlatUIUtils.lerp(x2, x3, t1), FlatUIUtils.lerp(y2, y3, t1), FlatUIUtils.lerp(x2, x3, t2), FlatUIUtils.lerp(y2, y3, t2), -1.000000000002E12, x3, y3, FlatUIUtils.lerp(x3, x1, t1), FlatUIUtils.lerp(y3, y1, t1));
    }

    public static void paintArrow(Graphics2D g2, int x2, int y2, int width, int height, int direction, boolean chevron, int arrowSize, float arrowThickness, float xOffset, float yOffset) {
        boolean vert;
        float aw2 = UIScale.scale(arrowSize + (chevron ? -1 : 0));
        float ah2 = chevron ? aw2 / 2.0f : (float)UIScale.scale(arrowSize / 2 + 1);
        boolean bl2 = vert = direction == 1 || direction == 5;
        if (!vert) {
            float temp = aw2;
            aw2 = ah2;
            ah2 = temp;
        }
        boolean extra = chevron;
        float ox = ((float)width - (aw2 + (float)extra)) / 2.0f + UIScale.scale(xOffset);
        float oy = ((float)height - (ah2 + (float)extra)) / 2.0f + UIScale.scale(yOffset);
        float ax2 = (float)x2 + (direction == 7 ? (float)(-Math.round(-(ox + aw2))) - aw2 : (float)Math.round(ox));
        float ay2 = (float)y2 + (direction == 1 ? (float)(-Math.round(-(oy + ah2))) - ah2 : (float)Math.round(oy));
        g2.translate(ax2, ay2);
        Shape arrowShape = FlatUIUtils.createArrowShape(direction, chevron, aw2, ah2);
        if (chevron) {
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(UIScale.scale(arrowThickness)));
            FlatUIUtils.drawShapePure(g2, arrowShape);
            g2.setStroke(oldStroke);
        } else {
            g2.fill(arrowShape);
        }
        g2.translate(-ax2, -ay2);
    }

    public static Shape createArrowShape(int direction, boolean chevron, float w2, float h2) {
        switch (direction) {
            case 1: {
                return FlatUIUtils.createPath(!chevron, 0.0, h2, w2 / 2.0f, 0.0, w2, h2);
            }
            case 5: {
                return FlatUIUtils.createPath(!chevron, 0.0, 0.0, w2 / 2.0f, h2, w2, 0.0);
            }
            case 7: {
                return FlatUIUtils.createPath(!chevron, w2, 0.0, 0.0, h2 / 2.0f, w2, h2);
            }
            case 3: {
                return FlatUIUtils.createPath(!chevron, 0.0, 0.0, w2, h2 / 2.0f, 0.0, h2);
            }
        }
        return new Path2D.Float();
    }

    public static Path2D createPath(double ... points) {
        return FlatUIUtils.createPath(true, points);
    }

    public static Path2D createPath(boolean close, double ... points) {
        Path2D.Float path = new Path2D.Float(1, points.length / 2 + (close ? 1 : 0));
        ((Path2D)path).moveTo(points[0], points[1]);
        int i2 = 2;
        while (i2 < points.length) {
            double p2 = points[i2];
            if (p2 == -1.000000000001E12) {
                ((Path2D)path).moveTo(points[i2 + 1], points[i2 + 2]);
                i2 += 3;
                continue;
            }
            if (p2 == -1.000000000002E12) {
                ((Path2D)path).quadTo(points[i2 + 1], points[i2 + 2], points[i2 + 3], points[i2 + 4]);
                i2 += 5;
                continue;
            }
            if (p2 == -1.000000000003E12) {
                ((Path2D)path).curveTo(points[i2 + 1], points[i2 + 2], points[i2 + 3], points[i2 + 4], points[i2 + 5], points[i2 + 6]);
                i2 += 7;
                continue;
            }
            if (p2 == -1.000000000004E12) {
                double x2 = points[i2 + 1];
                double y2 = points[i2 + 2];
                double arc = points[i2 + 3];
                int ip2 = i2 + 4;
                if (points[ip2] == -1.000000000002E12 || points[ip2] == -1.000000000004E12) {
                    ++ip2;
                }
                Point2D p1 = path.getCurrentPoint();
                double x1 = p1.getX();
                double y1 = p1.getY();
                double x22 = points[ip2];
                double y22 = points[ip2 + 1];
                double d1 = FlatUIUtils.distance(x2, y2, x1, y1);
                double d2 = FlatUIUtils.distance(x2, y2, x22, y22);
                double t1 = 1.0 - 1.0 / d1 * arc;
                double t2 = 1.0 / d2 * arc;
                ((Path2D)path).lineTo(FlatUIUtils.lerp(x1, x2, t1), FlatUIUtils.lerp(y1, y2, t1));
                ((Path2D)path).quadTo(x2, y2, FlatUIUtils.lerp(x2, x22, t2), FlatUIUtils.lerp(y2, y22, t2));
                i2 += 4;
                continue;
            }
            if (p2 == -1.000000000005E12) {
                path.closePath();
                ++i2;
                continue;
            }
            ((Path2D)path).lineTo(p2, points[i2 + 1]);
            i2 += 2;
        }
        if (close) {
            path.closePath();
        }
        return path;
    }

    private static double lerp(double v1, double v2, double t2) {
        return v1 * (1.0 - t2) + v2 * t2;
    }

    private static double distance(double x1, double y1, double x2, double y2) {
        double dx2 = x2 - x1;
        double dy2 = y2 - y1;
        return Math.sqrt(dx2 * dx2 + dy2 * dy2);
    }

    public static void drawShapePure(Graphics2D g2, Shape shape) {
        Object oldStrokeControl = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.translate(0.5, 0.5);
        g2.draw(shape);
        g2.translate(-0.5, -0.5);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldStrokeControl);
    }

    public static void drawString(JComponent c2, Graphics g2, String text, int x2, int y2) {
        HiDPIUtils.drawStringWithYCorrection(c2, (Graphics2D)g2, text, x2, y2);
    }

    public static void drawStringUnderlineCharAt(JComponent c2, Graphics g2, String text, int underlinedIndex, int x2, int y2) {
        if (underlinedIndex >= 0 && UIScale.getUserScaleFactor() > 1.0f) {
            g2 = new Graphics2DProxy((Graphics2D)g2){

                @Override
                public void fillRect(int x2, int y2, int width, int height) {
                    if (height == 1) {
                        height = Math.round(UIScale.scale(0.9f));
                        y2 += height - 1;
                    }
                    super.fillRect(x2, y2, width, height);
                }
            };
        }
        HiDPIUtils.drawStringUnderlineCharAtWithYCorrection(c2, (Graphics2D)g2, text, underlinedIndex, x2, y2);
    }

    public static boolean hasOpaqueBeenExplicitlySet(JComponent c2) {
        boolean oldOpaque = c2.isOpaque();
        LookAndFeel.installProperty(c2, "opaque", !oldOpaque);
        boolean explicitlySet = c2.isOpaque() == oldOpaque;
        LookAndFeel.installProperty(c2, "opaque", oldOpaque);
        return explicitlySet;
    }

    public static boolean isUseSharedUIs() {
        return useSharedUIs;
    }

    public static boolean setUseSharedUIs(boolean useSharedUIs) {
        boolean old = FlatUIUtils.useSharedUIs;
        FlatUIUtils.useSharedUIs = useSharedUIs;
        return old;
    }

    public static ComponentUI createSharedUI(Object key, Supplier<ComponentUI> newInstanceSupplier) {
        if (!useSharedUIs) {
            return newInstanceSupplier.get();
        }
        return sharedUIinstances.computeIfAbsent(UIManager.getLookAndFeel(), k2 -> new IdentityHashMap()).computeIfAbsent(key, k2 -> (ComponentUI)newInstanceSupplier.get());
    }

    public static boolean canUseSharedUI(JComponent c2) {
        return !FlatStylingSupport.hasStyleProperty(c2);
    }

    private static class NonUIResourceBorder
    implements Border {
        private final Border delegate;

        NonUIResourceBorder(Border delegate) {
            this.delegate = delegate;
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            this.delegate.paintBorder(c2, g2, x2, y2, width, height);
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            return this.delegate.getBorderInsets(c2);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.delegate.isBorderOpaque();
        }
    }

    public static class RepaintFocusListener
    implements FocusListener {
        private final Component repaintComponent;
        private final Predicate<Component> repaintCondition;

        public RepaintFocusListener(Component repaintComponent, Predicate<Component> repaintCondition) {
            this.repaintComponent = repaintComponent;
            this.repaintCondition = repaintCondition;
        }

        @Override
        public void focusGained(FocusEvent e2) {
            if (this.repaintCondition == null || this.repaintCondition.test(this.repaintComponent)) {
                this.repaintComponent.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent e2) {
            if (this.repaintCondition == null || this.repaintCondition.test(this.repaintComponent)) {
                this.repaintComponent.repaint();
            }
        }
    }
}

